using System;
using Server;
using Server.Items;
using Server.Spells;
using System.Collections;

namespace Server.Mobiles
{
	public class FireDaemon : BaseCreature
	{
		public override WeaponAbility GetWeaponAbility()
		{
			switch ( Utility.Random( 3 ) )
			{
				default:
					case 0: return WeaponAbility.DoubleStrike;
					case 1: return WeaponAbility.ArmorIgnore;
					case 2: return WeaponAbility.ConcussionBlow;
			}
		}
		
		[Constructable]
		public FireDaemon() : base( AIType.AI_Necromage, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			SpeechHue = Utility.RandomDyedHue();
			Hue = Regions.FireRegion.RandomFireHue;
			Female = false;
			BodyValue = 38;
			BaseSoundID = 0x300;
			Name = NameList.RandomName( "daemon" );
			Title = "the Fire Daemon";

			SetStr( 516, 605 );
			SetDex( 106, 115 );
			SetInt( 266, 305 );

			SetHits( 1500, 2000 );
			SetMana( 2500 );

			SetDamage( 19, 25 );

			SetDamageType( ResistanceType.Fire, 60 );
			SetDamageType( ResistanceType.Physical, 20 );
			SetDamageType( ResistanceType.Energy, 20 );

			SetResistance( ResistanceType.Physical, 50, 70 );
			SetResistance( ResistanceType.Fire, 100 );
			SetResistance( ResistanceType.Cold, 30, 50 );
			SetResistance( ResistanceType.Poison, 50, 60 );
			SetResistance( ResistanceType.Energy, 50, 75 );

			SetSkill( SkillName.EvalInt, 77.6, 120.5 );
			SetSkill( SkillName.Necromancy, 120.6, 150.5 );
			SetSkill( SkillName.SpiritSpeak, 120.1, 150.5 );
			SetSkill( SkillName.Magery, 90.1, 150.1);
			SetSkill( SkillName.Anatomy, 80.5 );
			SetSkill( SkillName.Meditation, 110.0 );
			SetSkill( SkillName.MagicResist, 80.1, 85.0 );
			SetSkill( SkillName.Parry, 90.1, 95.1 );
			SetSkill( SkillName.Tactics, 100.0 );
			SetSkill( SkillName.Wrestling, 90.1, 120.0 );

			Fame = 19000;
			Karma = -15000;

			VirtualArmor = 65;

			AddItem( new NecromancerSpellbook( (UInt64)0xFFFF ) );
			PackItem( Loot.RandomScroll( 1, 2, SpellbookType.Necromancer ) );
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.UltraRich, 2 );
			AddLoot( LootPack.Rich, 2 );
			AddLoot( LootPack.HighScrolls, 4 );
		}

		public override bool CanRummageCorpses{ get{ return true; } }
		public override bool AlwaysMurderer{ get{ return true; } }
		public override bool Unprovokable{ get{ return true; } }
		public override bool Uncalmable{ get{ return true; } }
		public override Poison PoisonImmune{ get{ return Poison.Deadly; } }
		public override int TreasureMapLevel{ get{ return 5; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		public override HideType HideType{ get{ return HideType.Daemon; } }
		public override int Hides{ get{ return ( this.IsTeragon ) ? 20 : 5; } }
		
		public void SpawnFury( Mobile target )
		{
			Map map = this.Map;

			if ( map == null || target == null )
				return;

			int newSums = Utility.RandomMinMax( 2, 4 );

			for ( int i = 0; i < newSums; ++i )
			{
				SumFireFury fury = new SumFireFury();

				fury.Team = this.Team;
				fury.FightMode = FightMode.Closest;
				bool validLocation = false;
				Point3D loc = this.Location;

				for ( int j = 0; !validLocation && j < 10; ++j )
				{
					int x = X + Utility.Random( 6 ) - 1;
					int y = Y + Utility.Random( 6 ) - 1;
					int z = map.GetAverageZ( x, y );

					if ( validLocation = map.CanFit( x, y, this.Z, 16, false, false ) )
						loc = new Point3D( x, y, Z );
					else if ( validLocation = map.CanFit( x, y, z, 16, false, false ) )
						loc = new Point3D( x, y, z );
				}

				fury.MoveToWorld( loc, map );
				fury.Combatant = target;
				
				TimeSpan duration = TimeSpan.FromSeconds( 25.0 );

				new UnsummonTimer( this, fury, duration ).Start();
				fury.SummonEnd = DateTime.Now + duration;
			}
		}
		
		public override void AlterMeleeDamageTo( Mobile to, ref int damage )
		{
			damage = DecreaseDamage( to, damage );
			
			if ( to is Xanthos.Interfaces.IEvoCreature )
				damage *= 5;
		}

		public override void OnDamage( int amount, Mobile from, bool willKill, int typ )
		{
			base.OnDamage( amount, from, willKill, typ );

			if (from == null)
				return;
			
			if( 0.055 > Utility.RandomDouble() )
				SpawnFury( from );

			// 			from.Damage( Utility.Random( 20, 10 ), this );
			from.Stam -= Utility.Random( 5, 10 );
			from.Mana -= Utility.Random( 5, 10 );
		}

		public FireDaemon( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}
